<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Table extends Model 
{

    protected $table = 'tables';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function diners()
    {
        return $this->belongsToMany('App\Models\User', 'tables_diners', 'table_id', 'user_id');
    }

    public function tableState()
    {
        return $this->belongsTo('App\Models\TableState', 'table_state_id');
    }

    public function resturant()
    {
        return $this->hasOne('App\Models\Restaurant', 'restaurant_id');
    }

}